/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.refactoring;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.builder.ProjectBuildPath;
import com.aptana.editor.php.internal.builder.WorkspaceFolderBuildpath;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.IncludePHPEntryValue;
import com.aptana.editor.php.internal.refactoring.ConstructedIncludePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public final class RefactoringUtils {
    public static ConstructedIncludePath constructIncludePath(IModule from, IModule to) {
        IFile file;
        IBuildPath fromBuildPath = from.getBuildPath();
        IBuildPath toBuildPath = to.getBuildPath();
        Set fromDependencies = fromBuildPath.getDependencies();
        if (fromDependencies.equals(toBuildPath)) {
            String includePath = RefactoringUtils.constructPathFromRoot(to);
            return new ConstructedIncludePath(includePath, null, null);
        }
        if (fromDependencies.contains(toBuildPath)) {
            String includePath = RefactoringUtils.constructPathFromRoot(to);
            return new ConstructedIncludePath(includePath, null, null);
        }
        if (to instanceof LocalModule && !(file = ((LocalModule)to).getFile()).isSynchronized(1)) {
            try {
                file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                if (file.exists()) {
                    IModule alternativeToModule;
                    IProject project = file.getProject();
                    IBuildPath projectBuildPath = BuildPathManager.getInstance().getBuildPathByResource(project);
                    if (projectBuildPath != null && (alternativeToModule = projectBuildPath.getModule((Object)file)) != null) {
                        String includePath = RefactoringUtils.constructPathFromRoot(alternativeToModule);
                        return new ConstructedIncludePath(includePath, fromBuildPath, projectBuildPath);
                    }
                }
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Refactoring - Error while constructing an include-path (constructIncludePath)", (Throwable)e, (String)"com.aptana.editor.php/debug");
            }
        }
        String includePath = RefactoringUtils.constructPathFromRoot(to);
        return new ConstructedIncludePath(includePath, fromBuildPath, toBuildPath);
    }

    public static ConstructedIncludePath constructIncludePath(IModule from, IBuildPath toBuildPath, IPath toPath) {
        IBuildPath fromBuildPath = from.getBuildPath();
        Set fromDependencies = fromBuildPath.getDependencies();
        if (fromBuildPath.equals(toBuildPath) || fromDependencies.contains(toBuildPath)) {
            String includePath = RefactoringUtils.constructPathFromRoot(toPath);
            return new ConstructedIncludePath(includePath, null, null);
        }
        if (toBuildPath instanceof ProjectBuildPath || toBuildPath instanceof WorkspaceFolderBuildpath) {
            IProject project = null;
            project = toBuildPath instanceof ProjectBuildPath ? ((ProjectBuildPath)toBuildPath).getProject() : ((WorkspaceFolderBuildpath)toBuildPath).getFolder().getProject();
            IBuildPath projectBuildPath = BuildPathManager.getInstance().getBuildPathByResource(project);
            if (projectBuildPath != null) {
                String includePath = RefactoringUtils.constructPathFromRoot(toPath);
                return new ConstructedIncludePath(includePath, fromBuildPath, projectBuildPath);
            }
        }
        String includePath = RefactoringUtils.constructPathFromRoot(toPath);
        return new ConstructedIncludePath(includePath, fromBuildPath, toBuildPath);
    }

    public static Map<IModule, List<IncludePHPEntryValue>> getIncludes(IElementsIndex index, IModule module) {
        HashMap<IModule, ArrayList<IncludePHPEntryValue>> candidates = new HashMap<IModule, ArrayList<IncludePHPEntryValue>>();
        String moduleShortName = module.getShortName();
        Set<IModule> modules = index.getModules();
        for (IModule currentModule : modules) {
            List<IElementEntry> moduleEntries = index.getModuleEntries(currentModule);
            for (IElementEntry entry : moduleEntries) {
                IncludePHPEntryValue includeValue;
                Object entryValue = entry.getValue();
                if (!(entryValue instanceof IncludePHPEntryValue) || !(includeValue = (IncludePHPEntryValue)entryValue).getIncludePath().endsWith(moduleShortName)) continue;
                ArrayList<IncludePHPEntryValue> moduleValues = (ArrayList<IncludePHPEntryValue>)candidates.get(currentModule);
                if (moduleValues == null) {
                    moduleValues = new ArrayList<IncludePHPEntryValue>(1);
                    candidates.put(currentModule, moduleValues);
                }
                moduleValues.add(includeValue);
            }
        }
        HashMap<IModule, List<IncludePHPEntryValue>> result = new HashMap<IModule, List<IncludePHPEntryValue>>();
        for (Map.Entry entry : candidates.entrySet()) {
            IModule currentModule = (IModule)entry.getKey();
            List values = (List)entry.getValue();
            for (IncludePHPEntryValue value : values) {
                String includePathString = value.getIncludePath();
                Path includePath = new Path(includePathString);
                IModule resolvedModule = currentModule.getBuildPath().resolveRelativePath(currentModule, (IPath)includePath);
                if (resolvedModule == null || !resolvedModule.equals(module)) continue;
                ArrayList<IncludePHPEntryValue> moduleValues = (ArrayList<IncludePHPEntryValue>)result.get(currentModule);
                if (moduleValues == null) {
                    moduleValues = new ArrayList<IncludePHPEntryValue>(1);
                    result.put(currentModule, moduleValues);
                }
                moduleValues.add(value);
            }
        }
        return result;
    }

    private static String constructPathFromRoot(IModule module) {
        IPath path = module.getPath();
        StringBuilder result = new StringBuilder();
        String[] segments = path.segments();
        if (segments.length == 0) {
            return null;
        }
        int i = 0;
        while (i < segments.length - 1) {
            result.append(segments[i]);
            result.append('/');
            ++i;
        }
        result.append(segments[segments.length - 1]);
        return result.toString();
    }

    public static String constructPathFromRoot(IPath modulePath) {
        StringBuilder result = new StringBuilder();
        String[] segments = modulePath.segments();
        if (segments.length == 0) {
            return null;
        }
        int i = 0;
        while (i < segments.length - 1) {
            result.append(segments[i]);
            result.append('/');
            ++i;
        }
        result.append(segments[segments.length - 1]);
        return result.toString();
    }

    public static List<IncludePHPEntryValue> getModuleIncludes(IModule module) {
        return RefactoringUtils.getModuleIncludes(module, PHPGlobalIndexer.getInstance().getIndex());
    }

    public static List<IncludePHPEntryValue> getModuleIncludes(IModule module, IElementsIndex index) {
        ArrayList<IncludePHPEntryValue> result = new ArrayList<IncludePHPEntryValue>();
        List<IElementEntry> moduleEntries = index.getModuleEntries(module);
        for (IElementEntry entry : moduleEntries) {
            Object entryValue = entry.getValue();
            if (!(entryValue instanceof IncludePHPEntryValue)) continue;
            result.add((IncludePHPEntryValue)entryValue);
        }
        return result;
    }

    private RefactoringUtils() {
    }
}

